function [train_data,entest_data] = pca_lda_scale(train_data,train_labels,entest_data,setValue)
%setValue ==1 : ROI wflow/woflow/featureFusion= 30
%setValue ==2 : FPI  fpi=10
%setValue ==3 : BF   bfrS=20


 m = mean(train_data);
 s=std(train_data);
 train_data = bsxfun(@minus, train_data, m);
 entest_data  = bsxfun(@minus, entest_data, m);
 
 
% PCA

  [pca_coeff, pca_score , pca_latent]= pca(train_data);
   %pca_latent are the actual eigenvalues
    PCA_dim=0;Pov=[];

if setValue==1
    PCA_dim=30;
elseif setValue==2
    PCA_dim=10;
elseif setValue==3
    PCA_dim=20;
else
    disp('Incorrect Response , Please select 1, 2 or 3');
end
  
   if PCA_dim>0
       train_data = train_data * pca_coeff(:,1:PCA_dim);
       entest_data=entest_data*pca_coeff(:,1:PCA_dim);
   end
    
   %LDA
   [eigvector, eigvalue] = LDA(train_labels, [], train_data);
   LDA_dim=0;Pov_lda=[];
   for n=1:size(eigvalue,1)
       Pov_lda(n)=sum(eigvalue(1:n))/sum(eigvalue);
       if Pov_lda(n)>=1 % takes all the dimensions selected by PCA
           LDA_dim=n;
           break;
       end
   end

 if LDA_dim > 0
     
    train_data = train_data*eigvector(:,1:LDA_dim);
    entest_data=entest_data*eigvector(:,1:LDA_dim);
 end
 
 m = mean(train_data);
 s=std(train_data);
 
 % centre data - to have mean 0
 train_data = bsxfun(@minus, train_data, m);
 entest_data  = bsxfun(@minus, entest_data, m);
  
 % scale data - to have std 1
 train_data = bsxfun(@rdivide, train_data, s);
 entest_data  = bsxfun(@rdivide, entest_data, s);
end

